<?php
require_once 'config.php';
requireLogin();

// Handle user actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['action'])) {
        switch ($_POST['action']) {
            case 'add':
                $username = $_POST['username'];
                $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
                $packageId = $_POST['package_id'];
                $startDate = $_POST['start_date'];
                $durationDays = $pdo->query("SELECT duration_days FROM packages WHERE id = $packageId")->fetchColumn();
                $endDate = date('Y-m-d', strtotime($startDate . " + $durationDays days"));
                
                $stmt = $pdo->prepare("INSERT INTO users (username, password, package_id, start_date, end_date) VALUES (?, ?, ?, ?, ?)");
                $stmt->execute([$username, $password, $packageId, $startDate, $endDate]);
                $success = "تم إضافة المستخدم بنجاح";
                break;
                
            case 'edit':
                $id = $_POST['id'];
                $username = $_POST['username'];
                $packageId = $_POST['package_id'];
                $startDate = $_POST['start_date'];
                $endDate = $_POST['end_date'];
                $isActive = isset($_POST['is_active']) ? 1 : 0;
                
                $stmt = $pdo->prepare("UPDATE users SET username = ?, package_id = ?, start_date = ?, end_date = ?, is_active = ? WHERE id = ?");
                $stmt->execute([$username, $packageId, $startDate, $endDate, $isActive, $id]);
                $success = "تم تحديث المستخدم بنجاح";
                break;
                
            case 'delete':
                $id = $_POST['id'];
                $stmt = $pdo->prepare("DELETE FROM users WHERE id = ?");
                $stmt->execute([$id]);
                $success = "تم حذف المستخدم بنجاح";
                break;
        }
    }
}

// Get all users
$users = $pdo->query("SELECT u.*, p.name as package_name FROM users u LEFT JOIN packages p ON u.package_id = p.id ORDER BY u.created_at DESC")->fetchAll();
$packages = $pdo->query("SELECT * FROM packages WHERE is_active = 1")->fetchAll();

// Get user for editing
$editUser = null;
if (isset($_GET['edit'])) {
    $stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
    $stmt->execute([$_GET['edit']]);
    $editUser = $stmt->fetch();
}
?>
<!DOCTYPE html>
<html dir="rtl" lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>إدارة المستخدمين - <?php echo SITE_NAME; ?></title>
    <link rel="stylesheet" href="assets/style.css">
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="container">
        <h1>👥 إدارة المستخدمين</h1>
        
        <?php if (isset($success)): ?>
            <div class="alert success"><?php echo $success; ?></div>
        <?php endif; ?>
        
        <div class="section">
            <h2><?php echo $editUser ? 'تعديل مستخدم' : 'إضافة مستخدم جديد'; ?></h2>
            <form method="POST" class="form">
                <input type="hidden" name="action" value="<?php echo $editUser ? 'edit' : 'add'; ?>">
                <?php if ($editUser): ?>
                    <input type="hidden" name="id" value="<?php echo $editUser['id']; ?>">
                <?php endif; ?>
                
                <div class="form-row">
                    <div class="form-group">
                        <label>اسم المستخدم *</label>
                        <input type="text" name="username" value="<?php echo $editUser['username'] ?? ''; ?>" required>
                    </div>
                    
                    <?php if (!$editUser): ?>
                    <div class="form-group">
                        <label>كلمة المرور *</label>
                        <input type="text" name="password" value="<?php echo bin2hex(random_bytes(4)); ?>" required>
                    </div>
                    <?php endif; ?>
                </div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label>الباقة *</label>
                        <select name="package_id" required>
                            <option value="">اختر الباقة</option>
                            <?php foreach ($packages as $pkg): ?>
                                <option value="<?php echo $pkg['id']; ?>" <?php echo ($editUser && $editUser['package_id'] == $pkg['id']) ? 'selected' : ''; ?>>
                                    <?php echo $pkg['name']; ?> (<?php echo $pkg['duration_days']; ?> يوم)
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label>تاريخ البداية *</label>
                        <input type="date" name="start_date" value="<?php echo $editUser['start_date'] ?? date('Y-m-d'); ?>" required>
                    </div>
                    
                    <?php if ($editUser): ?>
                    <div class="form-group">
                        <label>تاريخ الانتهاء *</label>
                        <input type="date" name="end_date" value="<?php echo $editUser['end_date']; ?>" required>
                    </div>
                    <?php endif; ?>
                </div>
                
                <?php if ($editUser): ?>
                <div class="form-group">
                    <label>
                        <input type="checkbox" name="is_active" <?php echo $editUser['is_active'] ? 'checked' : ''; ?>>
                        الحساب نشط
                    </label>
                </div>
                <?php endif; ?>
                
                <button type="submit" class="btn"><?php echo $editUser ? 'تحديث' : 'إضافة'; ?></button>
                <?php if ($editUser): ?>
                    <a href="users.php" class="btn btn-secondary">إلغاء</a>
                <?php endif; ?>
            </form>
        </div>
        
        <div class="section">
            <h2>قائمة المستخدمين</h2>
            <table>
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>اسم المستخدم</th>
                        <th>الباقة</th>
                        <th>تاريخ البداية</th>
                        <th>تاريخ الانتهاء</th>
                        <th>الحالة</th>
                        <th>الإجراءات</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($users as $user): ?>
                    <tr>
                        <td><?php echo $user['id']; ?></td>
                        <td><?php echo htmlspecialchars($user['username']); ?></td>
                        <td><?php echo $user['package_name']; ?></td>
                        <td><?php echo $user['start_date']; ?></td>
                        <td><?php echo $user['end_date']; ?></td>
                        <td>
                            <?php if ($user['is_active'] && strtotime($user['end_date']) >= time()): ?>
                                <span class="badge active">نشط</span>
                            <?php else: ?>
                                <span class="badge inactive">منتهي</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <a href="?edit=<?php echo $user['id']; ?>" class="btn-small">تعديل</a>
                            <a href="generate_playlist.php?user=<?php echo $user['id']; ?>" class="btn-small" target="_blank">الرابط</a>
                            <form method="POST" style="display:inline;" onsubmit="return confirm('هل أنت متأكد من الحذف؟');">
                                <input type="hidden" name="action" value="delete">
                                <input type="hidden" name="id" value="<?php echo $user['id']; ?>">
                                <button type="submit" class="btn-small btn-danger">حذف</button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</body>
</html>
