<?php
/**
 * IPTV Panel - Manual Setup
 * إعداد يدوي بعد إنشاء القاعدة من cPanel
 */

// Check if config exists
if (file_exists('config.php')) {
    require_once 'config.php';
    $configExists = true;
} else {
    $configExists = false;
}

$step = $_GET['step'] ?? 1;
$errors = [];
$success = [];

// Step 1: Create config file
if ($step == 1 && $_SERVER['REQUEST_METHOD'] === 'POST') {
    $dbHost = $_POST['db_host'];
    $dbName = $_POST['db_name'];
    $dbUser = $_POST['db_user'];
    $dbPass = $_POST['db_pass'];
    $siteUrl = $_POST['site_url'];
    
    // Test connection
    try {
        $testPdo = new PDO("mysql:host=$dbHost;dbname=$dbName;charset=utf8mb4", $dbUser, $dbPass);
        
        $configContent = "<?php
// IPTV Panel Configuration
define('DB_HOST', '$dbHost');
define('DB_NAME', '$dbName');
define('DB_USER', '$dbUser');
define('DB_PASS', '$dbPass');
define('SITE_NAME', 'IPTV Panel');
define('SITE_URL', '$siteUrl');
define('ADMIN_EMAIL', 'admin@iptv.local');
define('SESSION_LIFETIME', 3600);
define('MAX_LOGIN_ATTEMPTS', 5);
define('UPLOAD_DIR', __DIR__ . '/uploads/');
define('M3U_DIR', __DIR__ . '/playlists/');

if (!file_exists(UPLOAD_DIR)) mkdir(UPLOAD_DIR, 0755, true);
if (!file_exists(M3U_DIR)) mkdir(M3U_DIR, 0755, true);

try {
    \$pdo = new PDO(
        \"mysql:host=\" . DB_HOST . \";dbname=\" . DB_NAME . \";charset=utf8mb4\",
        DB_USER, DB_PASS,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false
        ]
    );
} catch (PDOException \$e) {
    die(\"Database connection failed: \" . \$e->getMessage());
}

session_start();

function isLoggedIn() { return isset(\$_SESSION['admin_id']); }
function requireLogin() { if (!isLoggedIn()) { header('Location: login.php'); exit; } }
function generateToken(\$length = 32) { return bin2hex(random_bytes(\$length)); }
function logAccess(\$userId, \$ipAddress, \$userAgent) {
    global \$pdo;
    \$stmt = \$pdo->prepare(\"INSERT INTO access_logs (user_id, ip_address, user_agent) VALUES (?, ?, ?)\");
    \$stmt->execute([\$userId, \$ipAddress, \$userAgent]);
}
?>";
        
        file_put_contents('config.php', $configContent);
        
        // Create directories
        if (!file_exists('uploads')) mkdir('uploads', 0755, true);
        if (!file_exists('playlists')) mkdir('playlists', 0755, true);
        
        header('Location: setup.php?step=2');
        exit;
        
    } catch (Exception $e) {
        $errors[] = 'خطأ في الاتصال: ' . $e->getMessage();
    }
}

// Step 2: Create admin account
if ($step == 2 && $_SERVER['REQUEST_METHOD'] === 'POST') {
    require_once 'config.php';
    
    $adminUser = $_POST['admin_user'];
    $adminPass = $_POST['admin_pass'];
    $hashedPass = password_hash($adminPass, PASSWORD_DEFAULT);
    
    try {
        // Check if admins table exists
        $result = $pdo->query("SHOW TABLES LIKE 'admins'");
        if ($result->rowCount() == 0) {
            $errors[] = 'يجب استيراد ملف database.sql أولاً من phpMyAdmin!';
        } else {
            // Clear existing admins and add new one
            $pdo->exec("DELETE FROM admins");
            $stmt = $pdo->prepare("INSERT INTO admins (username, password, email) VALUES (?, ?, ?)");
            $stmt->execute([$adminUser, $hashedPass, 'admin@iptv.local']);
            
            header('Location: setup.php?step=3');
            exit;
        }
    } catch (Exception $e) {
        $errors[] = 'خطأ: ' . $e->getMessage();
    }
}
?>
<!DOCTYPE html>
<html dir="rtl" lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>إعداد IPTV Panel</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }
        .setup-container {
            max-width: 800px;
            margin: 0 auto;
            background: white;
            border-radius: 10px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
            overflow: hidden;
        }
        .header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 30px;
            text-align: center;
        }
        .header h1 {
            font-size: 28px;
            margin-bottom: 10px;
        }
        .content {
            padding: 40px;
        }
        .steps {
            display: flex;
            justify-content: space-between;
            margin-bottom: 40px;
            position: relative;
        }
        .step {
            flex: 1;
            text-align: center;
            position: relative;
        }
        .step-number {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: #ddd;
            color: #666;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 10px;
            font-weight: bold;
        }
        .step.active .step-number {
            background: #667eea;
            color: white;
        }
        .step.completed .step-number {
            background: #28a745;
            color: white;
        }
        .step-title {
            font-size: 14px;
            color: #666;
        }
        .step.active .step-title {
            color: #667eea;
            font-weight: bold;
        }
        .form-group {
            margin-bottom: 20px;
        }
        label {
            display: block;
            margin-bottom: 8px;
            color: #555;
            font-weight: 500;
        }
        input, textarea {
            width: 100%;
            padding: 12px;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-size: 14px;
        }
        input:focus, textarea:focus {
            outline: none;
            border-color: #667eea;
        }
        button {
            background: #667eea;
            color: white;
            padding: 12px 30px;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            cursor: pointer;
            font-weight: 600;
        }
        button:hover {
            background: #5568d3;
        }
        .error {
            background: #fee;
            color: #c33;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        .success {
            background: #dfd;
            color: #363;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        .info {
            background: #e7f3ff;
            color: #004085;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
            line-height: 1.8;
        }
        .warning {
            background: #fff3cd;
            color: #856404;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        code {
            background: #f4f4f4;
            padding: 2px 6px;
            border-radius: 3px;
            font-family: monospace;
        }
        .checklist {
            list-style: none;
            padding: 0;
        }
        .checklist li {
            padding: 10px;
            margin-bottom: 10px;
            background: #f8f9fa;
            border-radius: 5px;
        }
        .checklist li:before {
            content: "✓ ";
            color: #28a745;
            font-weight: bold;
            margin-left: 10px;
        }
    </style>
</head>
<body>
    <div class="setup-container">
        <div class="header">
            <h1>🎬 إعداد IPTV Panel</h1>
            <p>معالج الإعداد السريع</p>
        </div>
        
        <div class="content">
            <div class="steps">
                <div class="step <?php echo $step >= 1 ? 'active' : ''; ?> <?php echo $step > 1 ? 'completed' : ''; ?>">
                    <div class="step-number">1</div>
                    <div class="step-title">قاعدة البيانات</div>
                </div>
                <div class="step <?php echo $step >= 2 ? 'active' : ''; ?> <?php echo $step > 2 ? 'completed' : ''; ?>">
                    <div class="step-number">2</div>
                    <div class="step-title">حساب المدير</div>
                </div>
                <div class="step <?php echo $step >= 3 ? 'active' : ''; ?>">
                    <div class="step-number">3</div>
                    <div class="step-title">اكتمل</div>
                </div>
            </div>
            
            <?php if (!empty($errors)): ?>
                <div class="error">
                    <?php foreach ($errors as $error): ?>
                        <div><?php echo $error; ?></div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
            
            <?php if ($step == 1): ?>
                <div class="warning">
                    <strong>⚠️ قبل المتابعة:</strong><br>
                    يجب إنشاء قاعدة البيانات من cPanel أولاً!
                </div>
                
                <div class="info">
                    <strong>الخطوات المطلوبة:</strong><br>
                    1. ادخل على cPanel → MySQL Databases<br>
                    2. أنشئ قاعدة بيانات جديدة<br>
                    3. أنشئ مستخدم وأضفه للقاعدة مع جميع الصلاحيات<br>
                    4. ادخل على phpMyAdmin<br>
                    5. اختر القاعدة واستورد ملف <code>database.sql</code><br>
                    6. املأ البيانات أدناه
                </div>
                
                <form method="POST">
                    <div class="form-group">
                        <label>عنوان الخادم</label>
                        <input type="text" name="db_host" value="localhost" required>
                    </div>
                    <div class="form-group">
                        <label>اسم قاعدة البيانات (الاسم الكامل مع البادئة)</label>
                        <input type="text" name="db_name" placeholder="kharab7esh_d_iptv_panel" required>
                    </div>
                    <div class="form-group">
                        <label>اسم المستخدم (الاسم الكامل مع البادئة)</label>
                        <input type="text" name="db_user" placeholder="kharab7esh_d_iptv_user" required>
                    </div>
                    <div class="form-group">
                        <label>كلمة المرور</label>
                        <input type="password" name="db_pass" required>
                    </div>
                    <div class="form-group">
                        <label>رابط الموقع</label>
                        <input type="url" name="site_url" value="<?php echo 'http://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']); ?>" required>
                    </div>
                    <button type="submit">التالي →</button>
                </form>
                
            <?php elseif ($step == 2): ?>
                <div class="info">
                    <strong>✅ تم الاتصال بقاعدة البيانات بنجاح!</strong><br>
                    الآن قم بإنشاء حساب المدير
                </div>
                
                <form method="POST">
                    <div class="form-group">
                        <label>اسم المستخدم</label>
                        <input type="text" name="admin_user" value="admin" required>
                    </div>
                    <div class="form-group">
                        <label>كلمة المرور</label>
                        <input type="password" name="admin_pass" required>
                        <small style="color: #666;">احفظ كلمة المرور في مكان آمن</small>
                    </div>
                    <button type="submit">إنشاء الحساب →</button>
                </form>
                
            <?php elseif ($step == 3): ?>
                <div class="success">
                    <h2 style="margin-bottom: 15px;">🎉 تم الإعداد بنجاح!</h2>
                    <p>النظام جاهز للاستخدام الآن</p>
                </div>
                
                <div class="info">
                    <strong>الخطوات التالية:</strong>
                    <ul class="checklist">
                        <li>سجل دخول إلى لوحة التحكم</li>
                        <li>ارفع ملفات M3U من صفحة القنوات</li>
                        <li>أنشئ باقات الاشتراك</li>
                        <li>أضف المستخدمين</li>
                        <li>احذف ملف setup.php للأمان</li>
                    </ul>
                </div>
                
                <a href="login.php" style="display: inline-block; background: #667eea; color: white; padding: 12px 30px; border-radius: 5px; text-decoration: none; font-weight: 600;">
                    تسجيل الدخول الآن →
                </a>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>
