<?php
require_once 'config.php';
requireLogin();

// Handle package actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['action'])) {
        switch ($_POST['action']) {
            case 'add':
                $stmt = $pdo->prepare("INSERT INTO packages (name, description, duration_days, price) VALUES (?, ?, ?, ?)");
                $stmt->execute([$_POST['name'], $_POST['description'], $_POST['duration_days'], $_POST['price']]);
                $success = "تم إضافة الباقة بنجاح";
                break;
                
            case 'edit':
                $stmt = $pdo->prepare("UPDATE packages SET name = ?, description = ?, duration_days = ?, price = ? WHERE id = ?");
                $stmt->execute([$_POST['name'], $_POST['description'], $_POST['duration_days'], $_POST['price'], $_POST['id']]);
                $success = "تم تحديث الباقة بنجاح";
                break;
                
            case 'delete':
                $stmt = $pdo->prepare("DELETE FROM packages WHERE id = ?");
                $stmt->execute([$_POST['id']]);
                $success = "تم حذف الباقة بنجاح";
                break;
        }
    }
}

$packages = $pdo->query("SELECT * FROM packages ORDER BY duration_days")->fetchAll();

$editPackage = null;
if (isset($_GET['edit'])) {
    $stmt = $pdo->prepare("SELECT * FROM packages WHERE id = ?");
    $stmt->execute([$_GET['edit']]);
    $editPackage = $stmt->fetch();
}
?>
<!DOCTYPE html>
<html dir="rtl" lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>إدارة الباقات - <?php echo SITE_NAME; ?></title>
    <link rel="stylesheet" href="assets/style.css">
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="container">
        <h1>📦 إدارة الباقات</h1>
        
        <?php if (isset($success)): ?>
            <div class="alert success"><?php echo $success; ?></div>
        <?php endif; ?>
        
        <div class="section">
            <h2><?php echo $editPackage ? 'تعديل باقة' : 'إضافة باقة جديدة'; ?></h2>
            <form method="POST" class="form">
                <input type="hidden" name="action" value="<?php echo $editPackage ? 'edit' : 'add'; ?>">
                <?php if ($editPackage): ?>
                    <input type="hidden" name="id" value="<?php echo $editPackage['id']; ?>">
                <?php endif; ?>
                
                <div class="form-row">
                    <div class="form-group">
                        <label>اسم الباقة *</label>
                        <input type="text" name="name" value="<?php echo $editPackage['name'] ?? ''; ?>" required>
                    </div>
                    <div class="form-group">
                        <label>المدة (بالأيام) *</label>
                        <input type="number" name="duration_days" value="<?php echo $editPackage['duration_days'] ?? '30'; ?>" required>
                    </div>
                    <div class="form-group">
                        <label>السعر</label>
                        <input type="number" step="0.01" name="price" value="<?php echo $editPackage['price'] ?? '0'; ?>">
                    </div>
                </div>
                
                <div class="form-group">
                    <label>الوصف</label>
                    <textarea name="description" rows="3"><?php echo $editPackage['description'] ?? ''; ?></textarea>
                </div>
                
                <button type="submit" class="btn"><?php echo $editPackage ? 'تحديث' : 'إضافة'; ?></button>
                <?php if ($editPackage): ?>
                    <a href="packages.php" class="btn btn-secondary">إلغاء</a>
                <?php endif; ?>
            </form>
        </div>
        
        <div class="section">
            <h2>قائمة الباقات</h2>
            <div class="packages-grid">
                <?php foreach ($packages as $pkg): ?>
                <div class="package-card">
                    <h3><?php echo htmlspecialchars($pkg['name']); ?></h3>
                    <div class="package-price"><?php echo $pkg['price']; ?> $</div>
                    <div class="package-duration"><?php echo $pkg['duration_days']; ?> يوم</div>
                    <p><?php echo htmlspecialchars($pkg['description']); ?></p>
                    <div class="package-actions">
                        <a href="?edit=<?php echo $pkg['id']; ?>" class="btn-small">تعديل</a>
                        <form method="POST" style="display:inline;" onsubmit="return confirm('هل أنت متأكد؟');">
                            <input type="hidden" name="action" value="delete">
                            <input type="hidden" name="id" value="<?php echo $pkg['id']; ?>">
                            <button type="submit" class="btn-small btn-danger">حذف</button>
                        </form>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</body>
</html>
