<?php
require_once 'config.php';
requireLogin();

// Get logs with pagination
$page = $_GET['page'] ?? 1;
$perPage = 50;
$offset = ($page - 1) * $perPage;

$totalLogs = $pdo->query("SELECT COUNT(*) FROM access_logs")->fetchColumn();
$totalPages = ceil($totalLogs / $perPage);

$logs = $pdo->query("
    SELECT al.*, u.username 
    FROM access_logs al 
    LEFT JOIN users u ON al.user_id = u.id 
    ORDER BY al.access_time DESC 
    LIMIT $perPage OFFSET $offset
")->fetchAll();
?>
<!DOCTYPE html>
<html dir="rtl" lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>سجلات الدخول - <?php echo SITE_NAME; ?></title>
    <link rel="stylesheet" href="assets/style.css">
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="container">
        <h1>📋 سجلات الدخول</h1>
        
        <div class="section">
            <table>
                <thead>
                    <tr>
                        <th>المستخدم</th>
                        <th>عنوان IP</th>
                        <th>المتصفح</th>
                        <th>وقت الدخول</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($logs as $log): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($log['username'] ?? 'غير معروف'); ?></td>
                        <td><?php echo htmlspecialchars($log['ip_address']); ?></td>
                        <td><small><?php echo htmlspecialchars(substr($log['user_agent'], 0, 50)); ?>...</small></td>
                        <td><?php echo $log['access_time']; ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            
            <div class="pagination">
                <?php if ($page > 1): ?>
                    <a href="?page=<?php echo $page - 1; ?>" class="btn-small">السابق</a>
                <?php endif; ?>
                
                <span>صفحة <?php echo $page; ?> من <?php echo $totalPages; ?></span>
                
                <?php if ($page < $totalPages): ?>
                    <a href="?page=<?php echo $page + 1; ?>" class="btn-small">التالي</a>
                <?php endif; ?>
            </div>
        </div>
    </div>
</body>
</html>
