<?php
/**
 * IPTV Panel - Installation Script
 * سكريبت التثبيت التلقائي
 */

$errors = [];
$success = [];

// Check PHP version
if (version_compare(PHP_VERSION, '7.4.0', '<')) {
    $errors[] = 'يتطلب PHP 7.4 أو أحدث. النسخة الحالية: ' . PHP_VERSION;
}

// Check required extensions
$requiredExtensions = ['pdo', 'pdo_mysql', 'mbstring', 'json'];
foreach ($requiredExtensions as $ext) {
    if (!extension_loaded($ext)) {
        $errors[] = "الإضافة المطلوبة غير مفعلة: $ext";
    }
}

// Handle installation
if ($_SERVER['REQUEST_METHOD'] === 'POST' && empty($errors)) {
    $dbHost = $_POST['db_host'];
    $dbName = $_POST['db_name'];
    $dbUser = $_POST['db_user'];
    $dbPass = $_POST['db_pass'];
    $adminUser = $_POST['admin_user'];
    $adminPass = $_POST['admin_pass'];
    $siteUrl = $_POST['site_url'];
    
    try {
        // Connect to MySQL database directly
        $pdo = new PDO("mysql:host=$dbHost;dbname=$dbName;charset=utf8mb4", $dbUser, $dbPass);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        
        // Read and execute SQL file
        $sql = file_get_contents('database.sql');
        $statements = array_filter(array_map('trim', explode(';', $sql)));
        
        foreach ($statements as $statement) {
            if (!empty($statement)) {
                $pdo->exec($statement);
            }
        }
        
        // Update admin credentials
        $hashedPass = password_hash($adminPass, PASSWORD_DEFAULT);
        $pdo->exec("DELETE FROM admins");
        $stmt = $pdo->prepare("INSERT INTO admins (username, password, email) VALUES (?, ?, ?)");
        $stmt->execute([$adminUser, $hashedPass, 'admin@iptv.local']);
        
        // Update config.php
        $configContent = "<?php
// IPTV Panel Configuration
define('DB_HOST', '$dbHost');
define('DB_NAME', '$dbName');
define('DB_USER', '$dbUser');
define('DB_PASS', '$dbPass');
define('SITE_NAME', 'IPTV Panel');
define('SITE_URL', '$siteUrl');
define('ADMIN_EMAIL', 'admin@iptv.local');
define('SESSION_LIFETIME', 3600);
define('MAX_LOGIN_ATTEMPTS', 5);
define('UPLOAD_DIR', __DIR__ . '/uploads/');
define('M3U_DIR', __DIR__ . '/playlists/');

if (!file_exists(UPLOAD_DIR)) mkdir(UPLOAD_DIR, 0755, true);
if (!file_exists(M3U_DIR)) mkdir(M3U_DIR, 0755, true);

try {
    \$pdo = new PDO(
        \"mysql:host=\" . DB_HOST . \";dbname=\" . DB_NAME . \";charset=utf8mb4\",
        DB_USER, DB_PASS,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false
        ]
    );
} catch (PDOException \$e) {
    die(\"Database connection failed: \" . \$e->getMessage());
}

session_start();

function isLoggedIn() { return isset(\$_SESSION['admin_id']); }
function requireLogin() { if (!isLoggedIn()) { header('Location: login.php'); exit; } }
function generateToken(\$length = 32) { return bin2hex(random_bytes(\$length)); }
function logAccess(\$userId, \$ipAddress, \$userAgent) {
    global \$pdo;
    \$stmt = \$pdo->prepare(\"INSERT INTO access_logs (user_id, ip_address, user_agent) VALUES (?, ?, ?)\");
    \$stmt->execute([\$userId, \$ipAddress, \$userAgent]);
}
?>";
        
        file_put_contents('config.php', $configContent);
        
        // Create directories
        if (!file_exists('uploads')) mkdir('uploads', 0755, true);
        if (!file_exists('playlists')) mkdir('playlists', 0755, true);
        
        $success[] = 'تم التثبيت بنجاح!';
        $success[] = 'يمكنك الآن <a href="login.php">تسجيل الدخول</a>';
        
        // Delete install.php for security
        @unlink(__FILE__);
        
    } catch (Exception $e) {
        $errors[] = 'خطأ في التثبيت: ' . $e->getMessage();
    }
}
?>
<!DOCTYPE html>
<html dir="rtl" lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تثبيت IPTV Panel</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .install-container {
            background: white;
            padding: 40px;
            border-radius: 10px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
            width: 100%;
            max-width: 600px;
        }
        h1 {
            text-align: center;
            color: #333;
            margin-bottom: 30px;
        }
        .form-group {
            margin-bottom: 20px;
        }
        label {
            display: block;
            margin-bottom: 5px;
            color: #555;
            font-weight: 500;
        }
        input {
            width: 100%;
            padding: 12px;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-size: 14px;
        }
        input:focus {
            outline: none;
            border-color: #667eea;
        }
        button {
            width: 100%;
            padding: 12px;
            background: #667eea;
            color: white;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            cursor: pointer;
            font-weight: 600;
        }
        button:hover {
            background: #5568d3;
        }
        .error {
            background: #fee;
            color: #c33;
            padding: 10px;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        .success {
            background: #dfd;
            color: #363;
            padding: 10px;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        .info {
            background: #e7f3ff;
            color: #004085;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        .section {
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 1px solid #eee;
        }
        .section:last-child {
            border-bottom: none;
        }
        h2 {
            color: #667eea;
            margin-bottom: 15px;
            font-size: 18px;
        }
    </style>
</head>
<body>
    <div class="install-container">
        <h1>🎬 تثبيت IPTV Panel</h1>
        
        <?php if (!empty($errors)): ?>
            <div class="error">
                <?php foreach ($errors as $error): ?>
                    <div><?php echo $error; ?></div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
        
        <?php if (!empty($success)): ?>
            <div class="success">
                <?php foreach ($success as $msg): ?>
                    <div><?php echo $msg; ?></div>
                <?php endforeach; ?>
            </div>
        <?php else: ?>
            <div class="info">
                <strong>مهم:</strong> يجب إنشاء قاعدة البيانات من cPanel أولاً!<br>
                1. ادخل على cPanel → MySQL Databases<br>
                2. أنشئ قاعدة بيانات جديدة<br>
                3. أضف مستخدم للقاعدة مع جميع الصلاحيات<br>
                4. استخدم البيانات هنا
            </div>
            
            <form method="POST">
                <div class="section">
                    <h2>إعدادات قاعدة البيانات</h2>
                    <div class="form-group">
                        <label>عنوان الخادم</label>
                        <input type="text" name="db_host" value="localhost" required>
                    </div>
                    <div class="form-group">
                        <label>اسم قاعدة البيانات</label>
                        <input type="text" name="db_name" value="iptv_panel" required>
                    </div>
                    <div class="form-group">
                        <label>اسم المستخدم</label>
                        <input type="text" name="db_user" value="root" required>
                    </div>
                    <div class="form-group">
                        <label>كلمة المرور</label>
                        <input type="password" name="db_pass">
                    </div>
                </div>
                
                <div class="section">
                    <h2>حساب المدير</h2>
                    <div class="form-group">
                        <label>اسم المستخدم</label>
                        <input type="text" name="admin_user" value="admin" required>
                    </div>
                    <div class="form-group">
                        <label>كلمة المرور</label>
                        <input type="password" name="admin_pass" required>
                    </div>
                </div>
                
                <div class="section">
                    <h2>إعدادات الموقع</h2>
                    <div class="form-group">
                        <label>رابط الموقع</label>
                        <input type="url" name="site_url" value="<?php echo 'http://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']); ?>" required>
                    </div>
                </div>
                
                <button type="submit">تثبيت الآن</button>
            </form>
        <?php endif; ?>
    </div>
</body>
</html>
