<?php
require_once 'config.php';
requireLogin();

// Get statistics
$stats = [
    'total_users' => $pdo->query("SELECT COUNT(*) FROM users")->fetchColumn(),
    'active_users' => $pdo->query("SELECT COUNT(*) FROM users WHERE is_active = 1 AND end_date >= CURDATE()")->fetchColumn(),
    'total_channels' => $pdo->query("SELECT COUNT(*) FROM channels WHERE is_active = 1")->fetchColumn(),
    'total_packages' => $pdo->query("SELECT COUNT(*) FROM packages WHERE is_active = 1")->fetchColumn()
];

// Get recent users
$recentUsers = $pdo->query("SELECT * FROM users ORDER BY created_at DESC LIMIT 10")->fetchAll();
?>
<!DOCTYPE html>
<html dir="rtl" lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>لوحة التحكم - <?php echo SITE_NAME; ?></title>
    <link rel="stylesheet" href="assets/style.css">
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="container">
        <h1>📊 لوحة التحكم</h1>
        
        <div class="stats-grid">
            <div class="stat-card">
                <div class="stat-icon">👥</div>
                <div class="stat-info">
                    <h3><?php echo $stats['total_users']; ?></h3>
                    <p>إجمالي المستخدمين</p>
                </div>
            </div>
            
            <div class="stat-card active">
                <div class="stat-icon">✅</div>
                <div class="stat-info">
                    <h3><?php echo $stats['active_users']; ?></h3>
                    <p>المستخدمين النشطين</p>
                </div>
            </div>
            
            <div class="stat-card">
                <div class="stat-icon">📺</div>
                <div class="stat-info">
                    <h3><?php echo $stats['total_channels']; ?></h3>
                    <p>القنوات المتاحة</p>
                </div>
            </div>
            
            <div class="stat-card">
                <div class="stat-icon">📦</div>
                <div class="stat-info">
                    <h3><?php echo $stats['total_packages']; ?></h3>
                    <p>الباقات المتاحة</p>
                </div>
            </div>
        </div>
        
        <div class="section">
            <h2>آخر المستخدمين المضافين</h2>
            <table>
                <thead>
                    <tr>
                        <th>اسم المستخدم</th>
                        <th>تاريخ البداية</th>
                        <th>تاريخ الانتهاء</th>
                        <th>الحالة</th>
                        <th>الإجراءات</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($recentUsers as $user): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($user['username']); ?></td>
                        <td><?php echo $user['start_date']; ?></td>
                        <td><?php echo $user['end_date']; ?></td>
                        <td>
                            <?php if ($user['is_active'] && strtotime($user['end_date']) >= time()): ?>
                                <span class="badge active">نشط</span>
                            <?php else: ?>
                                <span class="badge inactive">منتهي</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <a href="users.php?edit=<?php echo $user['id']; ?>" class="btn-small">تعديل</a>
                            <a href="generate_playlist.php?user=<?php echo $user['id']; ?>" class="btn-small">الرابط</a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</body>
</html>
