<?php
require_once 'config.php';

// Get user info
$userId = $_GET['user'] ?? null;
$username = $_GET['username'] ?? null;
$password = $_GET['password'] ?? null;

if ($userId) {
    // Admin generating playlist
    requireLogin();
    $stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
    $stmt->execute([$userId]);
    $user = $stmt->fetch();
} elseif ($username && $password) {
    // User accessing their playlist
    $stmt = $pdo->prepare("SELECT * FROM users WHERE username = ?");
    $stmt->execute([$username]);
    $user = $stmt->fetch();
    
    if (!$user || !password_verify($password, $user['password'])) {
        die("Invalid credentials");
    }
    
    // Log access
    logAccess($user['id'], $_SERVER['REMOTE_ADDR'], $_SERVER['HTTP_USER_AGENT']);
} else {
    die("Missing parameters");
}

if (!$user) {
    die("User not found");
}

// Check if subscription is active
if (!$user['is_active'] || strtotime($user['end_date']) < time()) {
    die("#EXTM3U\n#EXTINF:-1,انتهت صلاحية الاشتراك\nhttp://expired");
}

// Get all active channels
$channels = $pdo->query("SELECT * FROM channels WHERE is_active = 1 ORDER BY group_title, name")->fetchAll();

// Generate M3U content
header('Content-Type: audio/x-mpegurl');
header('Content-Disposition: attachment; filename="playlist_' . $user['username'] . '.m3u"');

echo "#EXTM3U\n";
echo "#EXTINF:-1,مرحباً " . $user['username'] . " - صلاحية حتى " . $user['end_date'] . "\n";
echo "http://welcome\n\n";

foreach ($channels as $channel) {
    echo "#EXTINF:-1";
    
    if ($channel['logo']) {
        echo ' tvg-logo="' . $channel['logo'] . '"';
    }
    
    if ($channel['group_title']) {
        echo ' group-title="' . $channel['group_title'] . '"';
    }
    
    echo ',' . $channel['name'] . "\n";
    
    // Add user credentials to URL if needed
    $url = $channel['url'];
    if (strpos($url, '?') !== false) {
        $url .= '&user=' . $user['username'];
    } else {
        $url .= '?user=' . $user['username'];
    }
    
    echo $url . "\n";
}
?>
