<?php
// IPTV Panel Configuration
// إعدادات النظام

// Database Configuration
define('DB_HOST', 'localhost');
define('DB_NAME', 'iptv_panel');
define('DB_USER', 'root');
define('DB_PASS', '');

// Site Configuration
define('SITE_NAME', 'IPTV Panel');
define('SITE_URL', 'http://localhost/iptv-panel');
define('ADMIN_EMAIL', 'admin@iptv.local');

// Security
define('SESSION_LIFETIME', 3600); // 1 hour
define('MAX_LOGIN_ATTEMPTS', 5);

// Paths
define('UPLOAD_DIR', __DIR__ . '/uploads/');
define('M3U_DIR', __DIR__ . '/playlists/');

// Create directories if not exist
if (!file_exists(UPLOAD_DIR)) {
    mkdir(UPLOAD_DIR, 0755, true);
}
if (!file_exists(M3U_DIR)) {
    mkdir(M3U_DIR, 0755, true);
}

// Database Connection
try {
    $pdo = new PDO(
        "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4",
        DB_USER,
        DB_PASS,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false
        ]
    );
} catch (PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}

// Start session
session_start();

// Helper Functions
function isLoggedIn() {
    return isset($_SESSION['admin_id']);
}

function requireLogin() {
    if (!isLoggedIn()) {
        header('Location: login.php');
        exit;
    }
}

function generateToken($length = 32) {
    return bin2hex(random_bytes($length));
}

function logAccess($userId, $ipAddress, $userAgent) {
    global $pdo;
    $stmt = $pdo->prepare("INSERT INTO access_logs (user_id, ip_address, user_agent) VALUES (?, ?, ?)");
    $stmt->execute([$userId, $ipAddress, $userAgent]);
}
?>
