<?php
require_once 'config.php';
requireLogin();

// Handle channel actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['action'])) {
        switch ($_POST['action']) {
            case 'add':
                $stmt = $pdo->prepare("INSERT INTO channels (name, url, logo, group_title) VALUES (?, ?, ?, ?)");
                $stmt->execute([$_POST['name'], $_POST['url'], $_POST['logo'], $_POST['group_title']]);
                $success = "تم إضافة القناة بنجاح";
                break;
                
            case 'delete':
                $stmt = $pdo->prepare("DELETE FROM channels WHERE id = ?");
                $stmt->execute([$_POST['id']]);
                $success = "تم حذف القناة بنجاح";
                break;
                
            case 'toggle':
                $stmt = $pdo->prepare("UPDATE channels SET is_active = NOT is_active WHERE id = ?");
                $stmt->execute([$_POST['id']]);
                $success = "تم تحديث حالة القناة";
                break;
        }
    }
}

// Handle M3U file upload
if (isset($_FILES['m3u_file'])) {
    $file = $_FILES['m3u_file'];
    if ($file['error'] === UPLOAD_ERR_OK) {
        $content = file_get_contents($file['tmp_name']);
        $lines = explode("\n", $content);
        
        $imported = 0;
        for ($i = 0; $i < count($lines); $i++) {
            $line = trim($lines[$i]);
            if (strpos($line, '#EXTINF:') === 0) {
                // Parse channel info
                preg_match('/tvg-logo="([^"]*)"/', $line, $logoMatch);
                preg_match('/group-title="([^"]*)"/', $line, $groupMatch);
                preg_match('/,(.*)$/', $line, $nameMatch);
                
                $logo = $logoMatch[1] ?? '';
                $group = $groupMatch[1] ?? 'عام';
                $name = $nameMatch[1] ?? 'قناة';
                
                // Get URL from next line
                if (isset($lines[$i + 1])) {
                    $url = trim($lines[$i + 1]);
                    if (!empty($url) && strpos($url, 'http') === 0) {
                        $stmt = $pdo->prepare("INSERT INTO channels (name, url, logo, group_title) VALUES (?, ?, ?, ?)");
                        $stmt->execute([$name, $url, $logo, $group]);
                        $imported++;
                    }
                }
            }
        }
        $success = "تم استيراد $imported قناة بنجاح";
    }
}

// Get all channels
$search = $_GET['search'] ?? '';
$group = $_GET['group'] ?? '';

$query = "SELECT * FROM channels WHERE 1=1";
if ($search) {
    $query .= " AND name LIKE '%" . $pdo->quote($search) . "%'";
}
if ($group) {
    $query .= " AND group_title = " . $pdo->quote($group);
}
$query .= " ORDER BY group_title, name";

$channels = $pdo->query($query)->fetchAll();
$groups = $pdo->query("SELECT DISTINCT group_title FROM channels ORDER BY group_title")->fetchAll(PDO::FETCH_COLUMN);
?>
<!DOCTYPE html>
<html dir="rtl" lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>إدارة القنوات - <?php echo SITE_NAME; ?></title>
    <link rel="stylesheet" href="assets/style.css">
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="container">
        <h1>📺 إدارة القنوات</h1>
        
        <?php if (isset($success)): ?>
            <div class="alert success"><?php echo $success; ?></div>
        <?php endif; ?>
        
        <div class="section">
            <h2>رفع ملف M3U</h2>
            <form method="POST" enctype="multipart/form-data" class="form">
                <div class="form-group">
                    <label>اختر ملف M3U</label>
                    <input type="file" name="m3u_file" accept=".m3u,.m3u8" required>
                </div>
                <button type="submit" class="btn">رفع واستيراد القنوات</button>
            </form>
        </div>
        
        <div class="section">
            <h2>إضافة قناة يدوياً</h2>
            <form method="POST" class="form">
                <input type="hidden" name="action" value="add">
                <div class="form-row">
                    <div class="form-group">
                        <label>اسم القناة *</label>
                        <input type="text" name="name" required>
                    </div>
                    <div class="form-group">
                        <label>رابط القناة *</label>
                        <input type="url" name="url" required>
                    </div>
                </div>
                <div class="form-row">
                    <div class="form-group">
                        <label>رابط الشعار</label>
                        <input type="url" name="logo">
                    </div>
                    <div class="form-group">
                        <label>المجموعة</label>
                        <input type="text" name="group_title" value="عام">
                    </div>
                </div>
                <button type="submit" class="btn">إضافة القناة</button>
            </form>
        </div>
        
        <div class="section">
            <h2>قائمة القنوات (<?php echo count($channels); ?>)</h2>
            
            <form method="GET" class="filter-form">
                <input type="text" name="search" placeholder="بحث..." value="<?php echo htmlspecialchars($search); ?>">
                <select name="group">
                    <option value="">كل المجموعات</option>
                    <?php foreach ($groups as $g): ?>
                        <option value="<?php echo htmlspecialchars($g); ?>" <?php echo $g === $group ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($g); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
                <button type="submit" class="btn-small">بحث</button>
                <a href="channels.php" class="btn-small btn-secondary">إعادة تعيين</a>
            </form>
            
            <table>
                <thead>
                    <tr>
                        <th>الشعار</th>
                        <th>اسم القناة</th>
                        <th>المجموعة</th>
                        <th>الرابط</th>
                        <th>الحالة</th>
                        <th>الإجراءات</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($channels as $channel): ?>
                    <tr>
                        <td>
                            <?php if ($channel['logo']): ?>
                                <img src="<?php echo htmlspecialchars($channel['logo']); ?>" alt="" style="width:40px;height:40px;object-fit:contain;">
                            <?php else: ?>
                                📺
                            <?php endif; ?>
                        </td>
                        <td><?php echo htmlspecialchars($channel['name']); ?></td>
                        <td><?php echo htmlspecialchars($channel['group_title']); ?></td>
                        <td><small><?php echo substr($channel['url'], 0, 50); ?>...</small></td>
                        <td>
                            <span class="badge <?php echo $channel['is_active'] ? 'active' : 'inactive'; ?>">
                                <?php echo $channel['is_active'] ? 'نشط' : 'معطل'; ?>
                            </span>
                        </td>
                        <td>
                            <form method="POST" style="display:inline;">
                                <input type="hidden" name="action" value="toggle">
                                <input type="hidden" name="id" value="<?php echo $channel['id']; ?>">
                                <button type="submit" class="btn-small">تبديل</button>
                            </form>
                            <form method="POST" style="display:inline;" onsubmit="return confirm('هل أنت متأكد؟');">
                                <input type="hidden" name="action" value="delete">
                                <input type="hidden" name="id" value="<?php echo $channel['id']; ?>">
                                <button type="submit" class="btn-small btn-danger">حذف</button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</body>
</html>
