# 🎬 IPTV Panel - نظام إدارة IPTV

نظام متكامل لإدارة خدمات IPTV مع لوحة تحكم احترافية

## ✨ المميزات

### 1. لوحة تحكم كاملة
- إحصائيات شاملة (المستخدمين، القنوات، الباقات)
- واجهة عربية سهلة الاستخدام
- تصميم متجاوب يعمل على جميع الأجهزة

### 2. إدارة المستخدمين
- إضافة مستخدمين جدد
- تحديد الباقة والمدة لكل مستخدم
- توليد username و password تلقائياً
- تفعيل/تعطيل الحسابات
- تحديد تاريخ البداية والانتهاء

### 3. إدارة القنوات
- رفع ملفات M3U مباشرة
- استيراد القنوات تلقائياً من الملف
- إضافة قنوات يدوياً
- تنظيم القنوات في مجموعات
- البحث والفلترة
- تفعيل/تعطيل القنوات

### 4. إدارة الباقات
- إنشاء باقات مختلفة (يومية، شهرية، سنوية)
- تحديد السعر والمدة
- وصف تفصيلي لكل باقة

### 5. توليد روابط M3U ديناميكية
- رابط خاص لكل مستخدم
- التحقق من صلاحية الاشتراك
- تسجيل عمليات الدخول
- حماية الروابط بـ username/password

### 6. سجلات الدخول
- تتبع جميع عمليات الدخول
- عرض IP Address والمتصفح
- معرفة وقت الدخول

## 📋 متطلبات التشغيل

- PHP 7.4 أو أحدث
- MySQL 5.7 أو أحدث
- Apache/Nginx
- mod_rewrite مفعل

## 🚀 التثبيت

### 1. إنشاء قاعدة البيانات

```bash
# افتح phpMyAdmin أو MySQL CLI
mysql -u root -p

# استورد ملف database.sql
source database.sql
```

أو استخدم phpMyAdmin:
1. افتح phpMyAdmin
2. أنشئ قاعدة بيانات جديدة اسمها `iptv_panel`
3. استورد ملف `database.sql`

### 2. تعديل إعدادات الاتصال

افتح ملف `config.php` وعدل البيانات:

```php
define('DB_HOST', 'localhost');
define('DB_NAME', 'iptv_panel');
define('DB_USER', 'root');        // اسم المستخدم
define('DB_PASS', '');            // كلمة المرور
define('SITE_URL', 'http://yourdomain.com/iptv-panel');
```

### 3. رفع الملفات

ارفع جميع الملفات إلى السيرفر في مجلد `iptv-panel`

### 4. ضبط الصلاحيات

```bash
chmod 755 uploads/
chmod 755 playlists/
```

## 🔐 تسجيل الدخول الأول

- **الرابط**: `http://yourdomain.com/iptv-panel/login.php`
- **اسم المستخدم**: `admin`
- **كلمة المرور**: `password`

⚠️ **مهم**: غير كلمة المرور فوراً بعد أول تسجيل دخول!

## 📖 طريقة الاستخدام

### 1. رفع القنوات

1. اذهب إلى **القنوات**
2. اختر **رفع ملف M3U**
3. اختر الملف (مثل `tv_channels_live_only.m3u`)
4. اضغط **رفع واستيراد القنوات**
5. سيتم استيراد جميع القنوات تلقائياً

### 2. إضافة مستخدم جديد

1. اذهب إلى **المستخدمين**
2. املأ البيانات:
   - اسم المستخدم (مثل: `user123`)
   - كلمة المرور (يتم توليدها تلقائياً)
   - اختر الباقة
   - حدد تاريخ البداية
3. اضغط **إضافة**

### 3. الحصول على رابط المستخدم

بعد إضافة المستخدم، اضغط على زر **الرابط** بجانب اسمه

سيظهر رابط مثل:
```
http://yourdomain.com/iptv-panel/generate_playlist.php?username=user123&password=pass123
```

أعط هذا الرابط للمستخدم ليضعه في تطبيق IPTV

### 4. استخدام الرابط في تطبيقات IPTV

المستخدم يمكنه استخدام الرابط في:
- **IPTV Smarters Pro**
- **TiviMate**
- **Perfect Player**
- **GSE Smart IPTV**
- **VLC Media Player**

## 🔗 أنواع الروابط

### رابط للمستخدم (User Playlist)
```
http://yourdomain.com/iptv-panel/generate_playlist.php?username=USER&password=PASS
```

### رابط من لوحة التحكم (Admin)
```
http://yourdomain.com/iptv-panel/generate_playlist.php?user=USER_ID
```

## 🛡️ الأمان

- جميع كلمات المرور مشفرة بـ bcrypt
- التحقق من صلاحية الاشتراك عند كل طلب
- تسجيل جميع عمليات الدخول
- حماية من SQL Injection
- جلسات آمنة

## 📁 هيكل الملفات

```
iptv-panel/
├── assets/
│   └── style.css          # ملف التصميم
├── includes/
│   └── header.php         # الهيدر المشترك
├── uploads/               # مجلد رفع الملفات
├── playlists/             # مجلد القوائم المولدة
├── config.php             # الإعدادات
├── database.sql           # قاعدة البيانات
├── login.php              # صفحة تسجيل الدخول
├── logout.php             # تسجيل الخروج
├── index.php              # لوحة التحكم الرئيسية
├── users.php              # إدارة المستخدمين
├── channels.php           # إدارة القنوات
├── packages.php           # إدارة الباقات
├── logs.php               # سجلات الدخول
├── generate_playlist.php  # توليد قوائم M3U
└── README.md              # هذا الملف
```

## 🔧 استكشاف الأخطاء

### خطأ في الاتصال بقاعدة البيانات
- تأكد من بيانات الاتصال في `config.php`
- تأكد من تشغيل MySQL
- تأكد من استيراد `database.sql`

### لا يتم رفع الملفات
- تأكد من صلاحيات المجلدات (755)
- تأكد من `upload_max_filesize` في php.ini

### الرابط لا يعمل
- تأكد من تفعيل mod_rewrite
- تأكد من صلاحية الاشتراك
- تحقق من username/password

## 📞 الدعم

للمساعدة أو الاستفسارات، يمكنك:
- فتح issue على GitHub
- التواصل عبر البريد الإلكتروني

## 📝 الترخيص

هذا المشروع مفتوح المصدر ومتاح للاستخدام الشخصي والتجاري

---

صنع بـ ❤️ للمجتمع العربي
