# 📖 دليل التثبيت على cPanel

## الخطوات بالتفصيل:

### 1️⃣ إنشاء قاعدة البيانات

1. ادخل على **cPanel**
2. ابحث عن **MySQL® Databases** أو **قواعد بيانات MySQL**
3. في قسم "Create New Database":
   - اكتب اسم القاعدة: `iptv_panel`
   - اضغط **Create Database**
   - ستكون القاعدة الكاملة مثل: `kharab7esh_d_iptv_panel`

### 2️⃣ إنشاء مستخدم للقاعدة

1. في نفس الصفحة، قسم "Add New User":
   - Username: `iptv_user`
   - Password: اختار كلمة مرور قوية (احفظها!)
   - اضغط **Create User**
   - المستخدم الكامل سيكون: `kharab7esh_d_iptv_user`

### 3️⃣ ربط المستخدم بالقاعدة

1. في قسم "Add User To Database":
   - اختر المستخدم: `kharab7esh_d_iptv_user`
   - اختر القاعدة: `kharab7esh_d_iptv_panel`
   - اضغط **Add**
2. في صفحة الصلاحيات:
   - اختر **ALL PRIVILEGES** (جميع الصلاحيات)
   - اضغط **Make Changes**

### 4️⃣ استيراد الجداول

1. ادخل على **phpMyAdmin** من cPanel
2. اختر قاعدة البيانات `kharab7esh_d_iptv_panel` من القائمة اليسرى
3. اضغط على تبويب **Import** أو **استيراد**
4. اضغط **Choose File** واختر ملف `database.sql`
5. اضغط **Go** أو **تنفيذ**
6. انتظر رسالة النجاح ✅

### 5️⃣ رفع الملفات

1. ارفع مجلد `iptv-panel` كامل إلى `public_html`
2. المسار النهائي: `public_html/iptv-panel/`

### 6️⃣ تعديل ملف الإعدادات

افتح ملف `config.php` وعدل البيانات:

```php
define('DB_HOST', 'localhost');
define('DB_NAME', 'kharab7esh_d_iptv_panel');  // اسم القاعدة الكامل
define('DB_USER', 'kharab7esh_d_iptv_user');   // اسم المستخدم الكامل
define('DB_PASS', 'كلمة_المرور_اللي_اخترتها');
define('SITE_URL', 'http://yourdomain.com/iptv-panel');
```

### 7️⃣ إنشاء حساب المدير

افتح phpMyAdmin مرة أخرى ونفذ هذا الأمر في تبويب SQL:

```sql
INSERT INTO admins (username, password, email) 
VALUES ('admin', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'admin@iptv.local');
```

**بيانات الدخول الافتراضية:**
- Username: `admin`
- Password: `password`

⚠️ **مهم جداً:** غير كلمة المرور فوراً بعد أول تسجيل دخول!

### 8️⃣ ضبط الصلاحيات

من File Manager في cPanel:
1. اضغط يمين على مجلد `uploads` → Change Permissions → 755
2. اضغط يمين على مجلد `playlists` → Change Permissions → 755

### 9️⃣ تسجيل الدخول

افتح المتصفح واذهب إلى:
```
http://yourdomain.com/iptv-panel/login.php
```

---

## 🔧 حل المشاكل الشائعة

### خطأ: Access denied
- تأكد من اسم المستخدم وكلمة المرور في `config.php`
- تأكد من إضافة المستخدم للقاعدة مع جميع الصلاحيات

### خطأ: Table doesn't exist
- تأكد من استيراد ملف `database.sql` بنجاح
- تحقق من وجود الجداول في phpMyAdmin

### الصفحة فارغة أو خطأ 500
- تحقق من ملف `error_log` في cPanel
- تأكد من نسخة PHP 7.4 أو أحدث
- تأكد من تفعيل الإضافات المطلوبة

### لا يتم رفع الملفات
- تحقق من صلاحيات المجلدات (755)
- تحقق من `upload_max_filesize` في PHP Settings

---

## ✅ التحقق من التثبيت

بعد التثبيت، تأكد من:
- [ ] تسجيل الدخول يعمل
- [ ] لوحة التحكم تظهر الإحصائيات
- [ ] يمكنك إضافة مستخدم جديد
- [ ] يمكنك رفع ملف M3U
- [ ] يمكنك توليد رابط playlist

---

## 📞 تحتاج مساعدة؟

إذا واجهت أي مشكلة:
1. تحقق من ملف `error_log` في cPanel
2. تأكد من جميع الخطوات أعلاه
3. تحقق من نسخة PHP (يجب 7.4+)

---

صنع بـ ❤️ للمجتمع العربي
